import os
from os.path import join, dirname, abspath

class Config:
    # Security Configuration
    SECRET_KEY = os.environ.get('SECRET_KEY') or os.urandom(32).hex()
    
    # MySQL Configuration - Simplified connection string
    SQLALCHEMY_DATABASE_URI = 'mysql+pymysql://root:Alvintinega1@localhost/team_pooling_db?charset=utf8mb4'
    
    
    
    # Engine options without auth_plugin
    SQLALCHEMY_ENGINE_OPTIONS = {
        'pool_pre_ping': True,
        'pool_recycle': 3600
    }
    
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    
    # File Upload Configuration
    BASE_DIR = dirname(dirname(abspath(__file__)))
    UPLOAD_FOLDER = join(BASE_DIR, 'uploads')
    ALLOWED_EXTENSIONS = {'csv', 'xlsx'}
    MAX_CONTENT_LENGTH = 16 * 1024 * 1024  # 16MB
    
    # Application Settings
    DEBUG = os.environ.get('FLASK_DEBUG', 'False') == 'True'
    
    @staticmethod
    def ensure_directories():
        """Ensure upload directory exists"""
        os.makedirs(Config.UPLOAD_FOLDER, exist_ok=True)